package com.pcloud.book.group.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.AppClickRecordBiz;
import com.pcloud.book.group.entity.AppClickRecord;
import com.pcloud.book.group.facade.AppClickRecordFacade;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/30 12:00
 **/
@RestController("appClickRecordFacade")
@RequestMapping("appClickRecord")
public class AppClickRecordFacadeImpl implements AppClickRecordFacade {

    @Autowired
    private AppClickRecordBiz appClickRecordBiz;

    @ApiOperation("新增应用作品点击记录")
    @PostMapping("createAppClickRecord")
    @Override
    public ResponseDto<?> createAppClickRecord(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("应用点击记录模型") AppClickRecord appClickRecord
    ) throws BizException {
        if (appClickRecord==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数为空！");
        }
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        appClickRecord.setWechatUserId(wechatUserId);
        return new ResponseDto<>(appClickRecordBiz.createAppClickRecord(appClickRecord));
    }

    @ApiOperation("根据类型按照时间获取资源服务点击人数")
    @GetMapping("getAppClickByTime")
    @Override
    public ResponseDto<?> getAppClickByTime(
            @RequestHeader("token") String token,
            @RequestParam(value = "joinGroupType", required = false) Integer joinGroupType,
            @RequestParam("timeType") @ApiParam("时间类型（1按天，2按小时）") Integer timeType,
            @RequestParam("startTime") @ApiParam("开始时间") String startTime,
            @RequestParam("endTime") @ApiParam("结束时间") String endTime
    ) throws BizException, PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)) {
            throw new PermissionException(PermissionException.PERMISSION_NOT_FOUND);
        }
        return new ResponseDto<>(appClickRecordBiz.getAppClickByTime(joinGroupType, timeType, startTime, endTime));
    }
}
