package com.pcloud.book.push.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.pcloud.book.push.biz.SelfPushBiz;
import com.pcloud.book.push.service.SelfPushService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @描述：个人号群发内部接口
 * @作者：zhuyajie
 * @创建时间：10:48 2019/12/10
 * @版本：1.0
 */
@RequestMapping("selfPushService")
@RestController("selfPushService")
public class SelfPushServiceImpl implements SelfPushService {

    @Autowired
    private SelfPushBiz selfPushBiz;

    @Override
    @RequestMapping(value = "/sendSelfMsgQuartz", method = RequestMethod.POST)
    public void sendSelfMsgQuartz(@RequestBody Map<String, Object> map) {
        Long pushId = JSON.parseObject(JSON.toJSONString(map.get("pushId")), new TypeReference<Long>() {});
        if (null ==pushId){
            return;
        }
        selfPushBiz.sendSelfMsgQuartz(pushId);
    }
}
