package com.pcloud.book.weixinclock.dao;

import com.pcloud.book.weixinclock.entity.WeixinClockTopic;
import com.pcloud.common.core.dao.BaseDao;

import java.util.Date;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/16 11:39
 */
public interface WeixinClockTopicDao extends BaseDao<WeixinClockTopic> {

    /**
     * 获取用户今天打卡情况
     * @param wxGroupId
     * @param wxUserId
     * @return
     */
    WeixinClockTopic getTopicByIds4Today(String wxGroupId, String wxUserId);

    /**
     * 获得用户的打卡天数
     * @param wxGroupId
     * @param wxUserId
     * @return
     */
    Long getClockCountByUser(String wxGroupId, String wxUserId);

    /**
     * 获取成员第一次打卡日期
     * @param wxUserId
     * @param wxGroupId
     * @return
     */
    Date getFirstClockDay(String wxUserId, String wxGroupId);

}
