package com.pcloud.book.copyright.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author lily
 * @date 2018/12/26 15:35
 */
@ApiModel
public class BookAuthServerDTO implements Serializable {

    private static final long serialVersionUID = 9178152999605620185L;
    @ApiModelProperty("图书id")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("服务标识")
    private List<Long> serveIds;

    public Boolean check(){
        return null == bookId || null == channelId || null == adviserId || CollectionUtils.isEmpty(serveIds);
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public List<Long> getServeIds() {
        return serveIds;
    }

    public void setServeIds(List<Long> serveIds) {
        this.serveIds = serveIds;
    }

    @Override
    public String toString() {
        return "BookAuthServerDTO{" +
                "bookId=" + bookId +
                ", channelId=" + channelId +
                ", adviserId=" + adviserId +
                ", serveIds=" + serveIds +
                '}';
    }
}
