package com.pcloud.book.adnews.enums;

import java.security.Key;

/**
 * 内容类型
 *
 * @author zhengyongqiang
 * @date 2019/8/16 17:25
 */
public enum AdNewsContentTypeEnum {

    MORNING(0, "早报"),
    EVENING(1, "晚报");

    public final Integer key;
    public final String description;

    AdNewsContentTypeEnum(Integer key, String description) {
        this.key = key;
        this.description = description;
    }

    public static String getDescriptionByKey(Integer key) {
        AdNewsContentTypeEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdNewsContentTypeEnum methodEnum = var1[var3];
            if (methodEnum.key.equals(key)) {
                return methodEnum.description;
            }
        }
        return null;
    }
}
