package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletAppOrProductDTO;
import com.pcloud.book.applet.dto.AppletRecordBookDTO;
import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.dto.ReadBookDayStatisDTO;
import com.pcloud.book.applet.entity.AppletRecord;
import com.pcloud.common.core.dao.BaseDao;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * (AppletRecord)表数据库访问层
 *
 * @author makejava
 * @since 2020-08-27 15:49:55
 */
public interface AppletRecordDao extends BaseDao<AppletRecord> {

    Map<Long, AppletUserBookcaseDTO> getBookMap(List<AppletRecordDTO> appletRecordDTOS4Book);

    void updateDeleteState(Long fromId, Integer recordType);

    List<Date> listReachableDate(Long wechatUserId);

    List<ReadBookDayStatisDTO> getReadBookWeekStatis(Long wechatUserId, String mondayDate, String sundayDate);

    List<AppletRecordBookDTO> getBooksByWechatUserId(Long wechatUserId);

    Long getStatisUserCount(Date prevMonday, Date prevSunday);

    Map<Long, AppletAppOrProductDTO> getAppOrProductBrowseCount(Integer recordType, List<Long> serveIds);
}
