package com.pcloud.book.applet.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.pcloud.book.applet.dao.AppletNewsCategoryDao;
import com.pcloud.book.applet.dao.AppletNewsClassifyDao;
import com.pcloud.book.applet.dto.AppletNewsCategoryDTO;
import com.pcloud.book.applet.dto.AppletNewsClassifyDTO;
import com.pcloud.book.applet.entity.AppletNewsCategory;
import com.pcloud.book.applet.entity.AppletNewsClassify;
import com.pcloud.book.applet.entity.AppletNewsClassifyUser;
import com.pcloud.common.core.dao.BaseDaoImpl;

@Component
public class AppletNewsCategoryDaoImpl extends BaseDaoImpl<AppletNewsCategory> implements AppletNewsCategoryDao {

    @Override
    public void batchCreate(List<AppletNewsCategory> categoryList) {
        getSessionTemplate().insert(getStatement("batchCreate"), categoryList);
    }

    @Override
    public void deletebyNewsId(Long appletNewsId) {
        getSessionTemplate().delete(getStatement("deletebyNewsId"), appletNewsId);
    }

    @Override
    public List<AppletNewsCategoryDTO> getByNewsId(Long appletNewsId) {
        return getSessionTemplate().selectList(getStatement("getByNewsId"),appletNewsId);
    }
}
