package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * (AppletRecordDayServe)实体类
 *
 * @author makejava
 * @since 2020-12-09 16:04:07
 */
@Data
public class AppletRecordDayServe extends BaseEntity {

    private static final long serialVersionUID = -73199055227905231L;

    private Long id;

    @ApiModelProperty("微信用户id")
    private Long wechatUserId;

    @ApiModelProperty("1资讯 2编辑群  3 模板群  4第三方群  5 作品 6 应用 7 书刊 8 好书推荐 9 精选书单")
    private Integer recordType;

    @ApiModelProperty("权益id")
    private Long rightsSettingId;

    @ApiModelProperty("书籍id")
    private Long bookId;

    @ApiModelProperty("渠道id")
    private Long channelId;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("来源id")
    private Long fromId;

    @ApiModelProperty("来源名称")
    private String fromName;

    @ApiModelProperty("跳转链接")
    private String linkUrl;

    @ApiModelProperty("公众号id")
    private Long accountSettingId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;

    @ApiModelProperty("是否删除 0 未删除 1删除")
    private Integer isDelete;

}