package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.SearchRecordDisSaleDao;
import com.pcloud.book.book.entity.SearchRecordDis;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

/**
 * 用户搜索记录（内容去重）(SearchRecordDisSale)表数据库访问层
 *
 * @author makejava
 * @since 2020-10-12 16:24:41
 */
@Repository("searchRecordDisSaleDaoImpl")
public class SearchRecordDisSaleDaoImpl extends BaseDaoImpl<SearchRecordDis> implements SearchRecordDisSaleDao {

    @Override
    public SearchRecordDis getByCondition(Long wechatUserId, String wxId, String content) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("wxId",wxId);
        map.put("content",content);
        return super.getSqlSession().selectOne(super.getStatement("getByCondition"),map);
    }

    @Override
    public void updateUserDeleteByWxId(String wxId, Boolean userDelete) {
        Map<String,Object> map=new HashMap<>();
        map.put("wxId",wxId);
        map.put("userDelete",userDelete);
        super.getSqlSession().update(super.getStatement("updateUserDeleteByWxId"),map);
    }

    @Override
    public void updateUserDeleteByWechatUserId(Long wechatUserId, Boolean userDelete) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("userDelete",userDelete);
        super.getSqlSession().update(super.getStatement("updateUserDeleteByWechatUserId"),map);
    }

}