package com.pcloud.book.clock.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.clock.biz.BookClockBiz;
import com.pcloud.book.clock.entity.BookClockInfo;
import com.pcloud.book.clock.facade.BookClockFacade;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.string.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:48
 * @Version 1.0
 */
@RequestMapping("/bookClock")
@RestController("bookClockFacade")
public class BookClockFacadeImpl implements BookClockFacade {

    @Autowired
    private BookClockBiz bookClockBiz;


    /**
     * 关联作品/应用及微信群
     * @param token
     * @param bookClockInfo
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "createBookGroupClock", method = RequestMethod.POST)
    public ResponseDto<?> createBookGroupClock(@RequestHeader String token, @RequestBody BookClockInfo bookClockInfo) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == bookClockInfo || null == bookClockInfo.getOriginId() || StringUtil.isEmpty(bookClockInfo.getOriginType())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        if(ListUtils.isEmpty(bookClockInfo.getBookGroupIdList()) && ListUtils.isEmpty(bookClockInfo.getClassifyIdList())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        if(ListUtils.isEmpty(bookClockInfo.getBookClockKeywordList())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        bookClockInfo.setCreateUser(adviserId);
        bookClockInfo.setUpdateUser(adviserId);
        return new ResponseDto<>(bookClockBiz.createBookGroupClock(bookClockInfo));
    }

    /**
     * 修改关联信息
     * @param token
     * @param bookClockInfo
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "updateBookGroupClock", method = RequestMethod.POST)
    public ResponseDto<?> updateBookGroupClock(@RequestHeader("token")String token, @RequestBody BookClockInfo bookClockInfo) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == bookClockInfo || null == bookClockInfo.getBookClockInfoId() || StringUtil.isEmpty(bookClockInfo.getUpdateType())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        bookClockInfo.setCreateUser(adviserId);
        bookClockInfo.setUpdateUser(adviserId);
        bookClockBiz.updateBookGroupClock(bookClockInfo);
        return new ResponseDto<>();
    }

    /**
     * 获取关联的基本信息
     * @param token
     * @param bookClockInfoId
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "getBookGroupClockBaseInfo", method = RequestMethod.GET)
    public ResponseDto<?> getBookGroupClockBaseInfo(@RequestHeader("token")String token, @RequestParam(value = "bookClockInfoId",required = false) Long bookClockInfoId) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == bookClockInfoId){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        return new ResponseDto<>(bookClockBiz.getBookGroupClockBaseInfo(bookClockInfoId));
    }

    /**
     * 获取该编辑已选的超级作者作品及应用
     * @param token
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "getAdviserHasSelected", method = RequestMethod.GET)
    public ResponseDto<?> getAdviserHasSelected(@RequestHeader("token") String token) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(bookClockBiz.getAdviserHasSelected(adviserId));
    }

    @Override
    @RequestMapping(value = "listBookGroupClock4Adviser", method = RequestMethod.GET)
    public ResponseDto<?> listBookGroupClock4Adviser(@RequestHeader("token") String token,
             @RequestParam(value = "name" ,required = false) String name,
             @RequestParam(value = "startDate", required = false) String startDate,
             @RequestParam(value = "endDate", required = false) String endDate,
             @RequestParam(value = "currentPage", required = false) Integer currentPage,
             @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"分页参数有误");
        }
        PageParam pageParam = new PageParam(currentPage,numPerPage);
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("name", name != null && "".equals(name.trim()) ? null : name);
        if (!StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {
            paramMap.put("startDate", startDate + " 00:00:00");
            paramMap.put("endDate", endDate + " 23:59:59");
        }
        paramMap.put("adviserId", adviserId);
        return new ResponseDto<>(bookClockBiz.listBookGroupClock(pageParam, paramMap));
    }

    /**
     * 删除关联信息
     * @param token
     * @param bookClockInfoId
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "deleteBookGroupClock", method = RequestMethod.GET)
    public ResponseDto<?> deleteBookGroupClock(@RequestHeader("token") String token,
                                               @RequestParam(value = "bookClockInfoId",required = false) Long bookClockInfoId) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == bookClockInfoId){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误！");
        }
        bookClockBiz.deleteBookGroupClock(bookClockInfoId,adviserId);
        return new ResponseDto<>();
    }


}
