package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.biz.WeworkTeacherBiz;
import com.pcloud.book.group.vo.WeworkTeacherBookBindVO;
import com.pcloud.book.group.vo.WeworkTeacherVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.ParamChecker;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 客服老师二维码配置相关接口
 *
 * @author guiq
 * @version 1.0
 * @since 2020年9月7日
 */
@RequestMapping("weworkTeacher")
@RestController("weworkTeacherFacade")
public class WeworkTeacherFacadeImpl {

    @Autowired
    private WeworkTeacherBiz weworkTeacherBiz;

    @ApiOperation(value = "新增客服老师", httpMethod = "POST")
    @RequestMapping(value = "addWxworkTeacher", method = RequestMethod.POST)
    ResponseDto<Long> addWxworkTeacher(@RequestHeader("token") String token, @RequestBody WeworkTeacherVO weworkTeacherVO) {
        SessionUtil.getInfoToken4Redis(token);
        return new ResponseDto<>(weworkTeacherBiz.addWxworkTeacher(weworkTeacherVO));
    }

    @ApiOperation(value = "删除客服老师", httpMethod = "GET")
    @RequestMapping(value = "deleteTeacherById", method = RequestMethod.GET)
    ResponseDto<?> deleteTeacherById(@RequestHeader("token") String token, @RequestParam("id") Long id) {
        SessionUtil.getInfoToken4Redis(token);
        weworkTeacherBiz.deleteTeacherById(id);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "修改客服老师", httpMethod = "POST")
    @RequestMapping(value = "updateWxworkTeacher", method = RequestMethod.POST)
    ResponseDto<Long> updateWxworkTeacher(@RequestHeader("token") String token, @RequestBody WeworkTeacherVO weworkTeacherVO) {
        SessionUtil.getInfoToken4Redis(token);
        return new ResponseDto<>(weworkTeacherBiz.updateWxworkTeacher(weworkTeacherVO));
    }

    @ApiOperation(value = "分页查询客服老师", httpMethod = "GET")
    @RequestMapping(value = "getWxworkTeacherList", method = RequestMethod.GET)
    ResponseDto<PageBeanNew<WeworkTeacherVO>> getWxworkTeacherList(@RequestHeader("token") String token,
                                                                   @RequestParam(value = "name", required = false) String name,
                                                                   @RequestParam(value = "isOpen", required = false) Integer isOpen,
                                                                   @RequestParam(value = "teacherType", required = false) Integer teacherType,
                                                                   @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                                                   @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage) {
        SessionUtil.getInfoToken4Redis(token);
        ParamChecker.checkPageParamIsAbsent(currentPage, numPerPage, "分页参数错误");
        return new ResponseDto<>(weworkTeacherBiz.getWxworkTeacherList(name, isOpen, teacherType, currentPage, numPerPage));
    }


    @ApiOperation(value = "客户端获取客服老师", httpMethod = "GET")
    @RequestMapping(value = "getWxworkTeacherList4Applet", method = RequestMethod.GET)
    ResponseDto<List<WeworkTeacherVO>> getWxworkTeacherList4Applet(@CookieValue("userInfo") String userInfo, @RequestParam(value = "bookId", required = false) Long bookId) {
        Cookie.getUserInfo(userInfo);
        return new ResponseDto<>(weworkTeacherBiz.queryAll(bookId));
    }


    @ApiOperation(value = "绑定图书与客服老师", httpMethod = "POST")
    @RequestMapping(value = "bindBookWxworkTeacher", method = RequestMethod.POST)
    ResponseDto<?> bindBookWxworkTeacher(@RequestHeader("token") String token, @RequestBody WeworkTeacherBookBindVO bindVO) {
        SessionUtil.getInfoToken4Redis(token);
        weworkTeacherBiz.bindBookWxworkTeacher(bindVO);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "删除绑定", httpMethod = "GET")
    @RequestMapping(value = "deleteBookWxworkTeacher", method = RequestMethod.GET)
    ResponseDto<?> deleteBookWxworkTeacher(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId) {
        SessionUtil.getInfoToken4Redis(token);
        weworkTeacherBiz.deleteBookWxworkTeacher(bookId);
        return new ResponseDto<>();
    }


    @ApiOperation(value = "分页获取绑定关系", httpMethod = "GET")
    @RequestMapping(value = "getBookWxworkTeacherList", method = RequestMethod.GET)
    ResponseDto<?> getBookWxworkTeacherList(@RequestHeader("token") String token,
                                            @RequestParam(value = "name", required = false) String name,
                                            @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                            @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage) {
        SessionUtil.getInfoToken4Redis(token);
        return new ResponseDto<>(weworkTeacherBiz.getBookWxworkTeacherList(name, currentPage, numPerPage));
    }
}
