package com.pcloud.book.push.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/10 19:34
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PlanClassifyDTO implements Serializable {
    private static final long serialVersionUID = 3890723321481608455L;

    @ApiModelProperty("计划id")
    private Long pushPlanId;

    @ApiModelProperty("书id")
    private Long bookId;

    @ApiModelProperty("书名")
    private String bookName;

    @ApiModelProperty("社群码id")
    private Long bookGroupId;

    @ApiModelProperty("社群码名称")
    private String groupQrcodeName;

    @ApiModelProperty("分类id")
    private Long classifyId;

    @ApiModelProperty("分类名称")
    private String classify;

    public Long getPushPlanId() {
        return pushPlanId;
    }

    public void setPushPlanId(Long pushPlanId) {
        this.pushPlanId = pushPlanId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    @Override
    public String toString() {
        return "PlanClassifyDTO{" +
                "pushPlanId=" + pushPlanId +
                ", bookId=" + bookId +
                ", bookName='" + bookName + '\'' +
                ", bookGroupId=" + bookGroupId +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", classifyId=" + classifyId +
                ", classify='" + classify + '\'' +
                '}';
    }
}
