package com.pcloud.book.push.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/3 10:02
 **/
@ApiModel("微信早晚报推送模型")
public class MorningEveningNews extends BaseEntity {

    private static final long serialVersionUID = 53098150399104256L;

    @ApiModelProperty("早报时间")
    private String morningTime;

    @ApiModelProperty("晚报时间")
    private String eveningTime;

    @ApiModelProperty("是否开启早报")
    private Boolean hasMorningOpen;

    @ApiModelProperty("是否开启晚报")
    private Boolean hasEveningOpen;

    @ApiModelProperty("发送次数")
    private Integer sendCount;

    @ApiModelProperty("开场语")
    private String startContent;

    @ApiModelProperty("结束语")
    private String endContent;

    @ApiModelProperty("是否开启开场语")
    private Boolean hasStartContent;

    @ApiModelProperty("是否开启结束语")
    private Boolean hasEndContent;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("修改人")
    private Long updateUser;

    public String getMorningTime() {
        return morningTime;
    }

    public void setMorningTime(String morningTime) {
        this.morningTime = morningTime;
    }

    public String getEveningTime() {
        return eveningTime;
    }

    public void setEveningTime(String eveningTime) {
        this.eveningTime = eveningTime;
    }

    public Boolean getHasMorningOpen() {
        return hasMorningOpen;
    }

    public void setHasMorningOpen(Boolean hasMorningOpen) {
        this.hasMorningOpen = hasMorningOpen;
    }

    public Boolean getHasEveningOpen() {
        return hasEveningOpen;
    }

    public void setHasEveningOpen(Boolean hasEveningOpen) {
        this.hasEveningOpen = hasEveningOpen;
    }

    public Integer getSendCount() {
        return sendCount;
    }

    public void setSendCount(Integer sendCount) {
        this.sendCount = sendCount;
    }

    public String getStartContent() {
        return startContent;
    }

    public void setStartContent(String startContent) {
        this.startContent = startContent;
    }

    public String getEndContent() {
        return endContent;
    }

    public void setEndContent(String endContent) {
        this.endContent = endContent;
    }

    public Boolean getHasStartContent() {
        return hasStartContent;
    }

    public void setHasStartContent(Boolean hasStartContent) {
        this.hasStartContent = hasStartContent;
    }

    public Boolean getHasEndContent() {
        return hasEndContent;
    }

    public void setHasEndContent(Boolean hasEndContent) {
        this.hasEndContent = hasEndContent;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public String toString() {
        return "MorningEveningNews{" +
                "morningTime='" + morningTime + '\'' +
                ", eveningTime='" + eveningTime + '\'' +
                ", hasMorningOpen=" + hasMorningOpen +
                ", hasEveningOpen=" + hasEveningOpen +
                ", sendCount=" + sendCount +
                ", startContent='" + startContent + '\'' +
                ", endContent='" + endContent + '\'' +
                ", hasStartContent=" + hasStartContent +
                ", hasEndContent=" + hasEndContent +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                "} " + super.toString();
    }
}
