package com.pcloud.book.applet.dto;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.applet.entity.AppletThirdResources;
import com.pcloud.book.applet.entity.AppletThirdResourcesRelation;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("小程序资讯")
public class AppletNewsDTO extends BaseDto {

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("资讯")
    private String newsName;
    @ApiModelProperty("来源")
    private String source;
    @ApiModelProperty("栏目id")
    private Long newsClassifyId;
    @ApiModelProperty("专业标签ID")
    private Long proLabelId;
    @ApiModelProperty("深度标签ID")
    private Long depLabelId;
    @ApiModelProperty("目的标签ID")
    private Long purLabelId;
    @ApiModelProperty("专业标签")
    private String proLabelName;
    @ApiModelProperty("深度标签")
    private String depLabelName;
    @ApiModelProperty("目的标签")
    private String purLabelName;
    @ApiModelProperty("文章版式（1多图文2单图文3纯图片4纯文本)")
    private Integer type;
    @ApiModelProperty("内容摘要")
    private String digest;
    @ApiModelProperty("预览图片1")
    private String pic1;
    @ApiModelProperty("预览图片2")
    private String pic2;
    @ApiModelProperty("预览图片3")
    private String pic3;
    @ApiModelProperty("文章内容")
    private String content;
    @ApiModelProperty("是否展示")
    private Boolean showState;
    @ApiModelProperty("是否删除")
    private Integer isDelete; ;
    @ApiModelProperty("分类名称")
    private String newsClassify;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    protected Date createTime;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    protected Date updateTime;

    @ApiModelProperty("第一级类型标识")
    private Long firstClassify;
    @ApiModelProperty("第二级类型标识")
    private Long secondClassify;
    @ApiModelProperty("年级标签id")
    private Long gradeLabelId;
    @ApiModelProperty("科目标签id")
    private Long subjectLabelId;
    @ApiModelProperty("权益分类id")
    private Long rightsClassifyId;

    private String firstClassifyContent;

    private String secondClassifyContent;

    private String gradeLabelIdContent;

    private String subjectLabelIdContent;

    @ApiModelProperty("权益分类")
    private String rightsClassifyContent;
    @ApiModelProperty("跳转类型（1原文编辑2直接跳转）")
    private Integer jumpType;
    @ApiModelProperty("跳转地址")
    private String jumpUrl;
    @ApiModelProperty("跳转外链编号")
    private String urlNumber;
    @ApiModelProperty("点击量pv/uv")
    private String clickPVUV;
    @ApiModelProperty("浏览量pv/uv")
    private String browsePVUV;
    @ApiModelProperty("自定义标识")
    private String customTag;
    @ApiModelProperty("自定义标识id")
    private Long customTagId;
    @ApiModelProperty("展示来源")
    private Integer showSource;
    @ApiModelProperty("展示第三方资源")
    private Integer showLink;
    @ApiModelProperty("浏览量pv")
    private Integer browseCount;
    @ApiModelProperty("选取的服务")
    List<AppletNewsServeDTO> appletNewsServeList;
    @ApiModelProperty("文章版式（1多图文2单图文3纯图片4纯文本)")
    private Integer newsType;
    @ApiModelProperty("名片id")
    private Long businessCardId;
    @ApiModelProperty("类型： 0默认   1指定名片")
    private Long businessCardType;
    @ApiModelProperty("类型： 0关   1开")
    private Long businessCardIsOpen;
    @ApiModelProperty("名片名称")
    private String businessCardName;
    @ApiModelProperty("名片头衔")
    private String businessCardTitle;
    @ApiModelProperty("名片头像")
    private String businessCardHeadPhoto;
    @ApiModelProperty("名片二维码")
    private String businessCardQrcode;
    @ApiModelProperty("名片微信号")
    private String businessCardWechatNum;
    @ApiModelProperty("名片电话")
    private String businessPhone;
    @ApiModelProperty("点击量pv")
    private Integer clickCount;


    @ApiModelProperty("类别")
    private List<AppletNewsCategoryDTO> categoryList;


    @ApiModelProperty("第三方资源")
    List<AppletThirdResources> thirdResourcesRelations;

    @ApiModelProperty("城市编码")
    private String cityCode;
    @ApiModelProperty("城市名")
    private String city;

    @ApiModelProperty("划线价")
    private String crossedPrice;

    @ApiModelProperty("评估价")
    private String appraisalPrice;

    @ApiModelProperty("评估价类型  0 文字  1 图片")
    private Integer appraisalType;

    @ApiModelProperty("评估价图片")
    private String appraisalImg;
}
