package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * (AppletRecord)实体类
 *
 * @author makejava
 * @since 2020-08-27 15:49:54
 */
@Data
public class AppletRecord extends BaseEntity {

    private static final long serialVersionUID = -82964720941123171L;

    private Long id;

    @ApiModelProperty("微信用户id")
    private Long wechatUserId;

    @ApiModelProperty("1资讯 2编辑群  3 模板群 4 作品 5 应用 6 书刊 7 好书推荐 8 精选书单")
    private Integer recordType;

    @ApiModelProperty("权益id")
    private Long rightsSettingId;

    @ApiModelProperty("书籍id")
    private Long bookId;

    @ApiModelProperty("渠道id")
    private Long channelId;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("来源id")
    private Long fromId;

    @ApiModelProperty("来源名称")
    private String fromName;

    @ApiModelProperty("公众号id")
    private Long accountSettingId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;

    @ApiModelProperty("是否删除 0 未删除 1删除")
    private Integer isDelete;

    @ApiModelProperty("应用或作品的跳转链接")
    private String linkUrl;

}