package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.BuyBookRequestBiz;
import com.pcloud.book.applet.dto.BuyBookRequetUserDTO;
import com.pcloud.book.applet.entity.BuyBookRequest;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * (BuyBookRequest)表控制层
 *
 * @author makejava
 * @since 2020-10-14 19:51:41
 */
@RestController("buyBookRequestFacade")
@RequestMapping("buyBookRequest")
public class BuyBookRequestFacade {

    @Autowired
    private BuyBookRequestBiz buyBookRequestBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(buyBookRequestBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage,
                                  @RequestParam(value = "agentId", required = false) Long agentId)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(buyBookRequestBiz.getList(currentPage, numPerPage, agentId));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@CookieValue("userInfo") String userInfo, @RequestBody BuyBookRequest buyBookRequest)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        buyBookRequest.setWechatUserId(wechatUserId);
        return new ResponseDto<>(buyBookRequestBiz.insert(buyBookRequest));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token, @RequestBody BuyBookRequest buyBookRequest) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        buyBookRequestBiz.update(buyBookRequest);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        buyBookRequestBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("获取购书流程填写用户数量")
    @GetMapping("getUserCount")
    public ResponseDto<BuyBookRequetUserDTO> getUserCount(@CookieValue("userInfo") String userInfo, @RequestParam(value = "topCount", defaultValue = "5") Integer topCount) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<BuyBookRequetUserDTO>(buyBookRequestBiz.getUserCount(topCount));
    }

}