package com.pcloud.book.es.entity;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/13 14:29
 **/
@Data
@Document(indexName = "book", type = "book_and_adviser")
public class ESBookAndAdviser  {


    /**
     * 书籍标识
     */
    @Id
    private String bookId;

    /**
     * 编辑书id
     */
    private String bookAdviserId;

    /**
     * 编辑标识
     */
    private String adviserId;

    /**
     * 渠道标识
     */
    private String channelId;

    /**
     * 模板标识
     */
    private String templetId;

    /**
     * 第二级类型
     */
    private String secondTempletId;

    /**
     * 是否是主编辑
     */
    private Boolean isMainEditor;

    /**
     * 类型编码
     */
    private String typeCode;

    /**
     * 书籍ISBN码
     */
    @Field(type = FieldType.String, index = FieldIndex.not_analyzed)
    private String isbn;

    /**
     * 书籍名称
     */
    @Field(type = FieldType.String, index = FieldIndex.not_analyzed)
    private String bookName;

    /**
     * 是否删除(书)
     */
    private String isBookDelete;

    /**
     * 是否删除(编辑书)
     */
    private String isBookAdviserDelete;

    /**
     * 最后更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastModifiedDate;

    /**
     * 编辑书创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createdDate;

    /**
     * 是否编辑书刊
     */
    private String isAdviserBook;

    /**
     * 年级标签id
     */
    private Long graLabelId;

    /**
     * 科目标签id
     */
    private Long subLabelId;

    /**
     * 版本标签id
     */
    private Long verLabelId;

    /**
     * 地域标签id
     */
    private Long areaLabelId;
    /**
     * 上下册标签id
     */
    private Long volLabelId;
    /**
     * 社群书id
     */
    private Long bookGroupId;
    /**
     * 社群书类型
     */
    private Integer joinGroupType;
    /**
     * 书刊访问数量
     */
    private Integer bookUserCount;
    /**
     * 书刊资源数量
     */
    private Integer resourceCount;
    /**
     * 是否基金支持
     */
    private Integer isFundSupport;
    /**
     * 基金书访问量公式（GMV*10+扫码*3+浏览量）
     */
    private BigDecimal fundBookValue;

}
