package com.pcloud.book.giftcoupon.entity;

import com.pcloud.book.applet.entity.AppletNewsCategory;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 专享礼券包表(GiftCouponPackage)实体类
 *
 * @author makejava
 * @since 2020-04-19 14:59:19
 */
@Data
public class GiftCouponPackage extends BaseEntity {

    /**
    * 封面图
    */
    private String coverPic;
    /**
    * 名称
    */
    private String title;
    /**
    * 有效期开始时间
    */
    private String validDateBegin;
    /**
    * 有效期结束时间
    */
    private String validDateEnd;
    /**
    * 面额
    */
    private Integer denomination;
    
    private Integer stock;
    /**
    * 每人领取上限
    */
    private Integer receiveLimit;

    /**
     * 券类型（2-书币券，1-课程券）
     */
    private Integer couponType;
    /**
     * 使用说明
     */
    private String instructions;
    /**
     * 课程券使用方式（1-链接兑取，2-复制码）
     */
    private Integer useType;
    /**
     * 兑换地址
     */
    private String exchangeAddress;
    /**
     * 跳转外链编号
     */
    private String urlNumber;

    private Long agentId;

    /**
     * 资源编号
     */
    private String resourceNumber;

    /**
     * 资源价格
     */
    private String price;

    /**
     * 资源描述
     */
    private String resourceDesc;

    /**
     * 划线价
     */
    private String crossedPrice;


    /**
     * 是否推荐到首页
     */
    private Boolean recToPage;

    /**
     * 作品还是应用
     */
    private String serveType;

    private String linkUrl;

    /**
     * 应用或者作品id
     */
    private Long serveId;

    /**
     * 第三方资源链接id
     */
    private Long thirdResourceId;

    /**
     * 是否上架
     */
    private Boolean onShelves;

    @ApiModelProperty("适用分类")
    List<GiftCategory> GiftCategoryList;
}