package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.PushBookGroupUpdateDao;
import com.pcloud.book.group.entity.PushBookGroupUpdate;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/10/28 12:09
 **/
@Component("pushBookGroupUpdateDao")
public class PushBookGroupUpdateDaoImpl extends BaseDaoImpl<PushBookGroupUpdate> implements PushBookGroupUpdateDao {
    @Override
    public Integer batchInsert(List<PushBookGroupUpdate> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public PushBookGroupUpdate getEarliestPushBookGroupUpdate() {
        return super.getSqlSession().selectOne(getStatement("getEarliestPushBookGroupUpdate"));
    }

    @Override
    public Integer updateIsPushTrue(Long id) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        return super.getSqlSession().update(getStatement("updateIsPushTrue"), map);
    }
}
