package com.pcloud.book.rightsSetting.constants;

import com.pcloud.common.constant.CacheConstant;
import com.pcloud.common.core.constant.ProductTypeConstant;
import com.pcloud.common.enums.AppTypeEnum;

public class RightsSettingConstant {

    /**
     * 所属k12教育的编辑书刊分类id--生产uat
     */
    public static final Long[] K12_TEMPLET_ID = {48L, 59L, 46L, 40L, 65L, 60L, 131L,73L};
    /**
     * 所属k12教育的编辑书刊分类id--测试环境
     */
    public static final Long[] K12_TEMPLET_ID_TEST = {48L, 59L, 46L, 40L, 65L, 60L, 136L, 73L};
    /**
     * 所属k12教育的书刊分类id---有上下册分类
     */
    public static final Long[] K12_VOLUME_ID = {48L, 59L, 46L, 40L, 65L, 10L, 60L};
    /**
     * 所属k12教育/学前教育的书刊分类id---有版本分类
     */
    public static final Long[] K12_VERSION_ID = {48L, 59L, 46L, 40L, 65L, 73L, 60L};
    /**
     * 医疗保健编辑书刊分类id
     */
    public static final Long[] MEDICAL_INSURANCE_TEMPLET_ID = {63L};

    /**
     *小程序不支持展示的应用类型
     */
    public static final String[] APPLET_APP_NOT_SUPPORT = {
            AppTypeEnum.INTERACT.value, AppTypeEnum.MEMBER.value, AppTypeEnum.ENROLL.value};
    /**
     *小程序不支持展示的商品类型
     */
    public static final String[] APPLET_PRODUCT_NOT_SUPPORT = {ProductTypeConstant.QA,ProductTypeConstant.TOOL,
            ProductTypeConstant.TUTORIAL,ProductTypeConstant.ATTENDANCE_TASK, ProductTypeConstant.MEMBER,
            ProductTypeConstant.THIRDPARTY};

    public static final Integer MAX_ITEM_COUNT = 3;


    /**
     * 答案课程弹窗
     */
    public static final String ANSWER_POPUP = CacheConstant.BOOK +"RIGHTS_SETTING:answer_popup";

    /**
     * 品牌方课程弹窗-线上网课
     */
    public static final String COURSE_POPUP = CacheConstant.BOOK +"RIGHTS_SETTING:course_popup";
    /**
     * 答案课程中视频课直播课引流
     */
    public static final String ANSWER_COURSE = CacheConstant.BOOK +"RIGHTS_SETTING:answer_course";
    /**
     * 答案课程中专享社群引流
     */
    public static final String ANSWER_GROUP = CacheConstant.BOOK +"RIGHTS_SETTING:answer_group";

    /**
     * feat: [1003898] 小睿书扫码落地页改版
     * K12 分类
     * <p>
     * 0: {assistTempletId: 48L, typeCode: "IMPORTED_HIGER", templetName: "K12同步教材教辅",…}
     * 1: {assistTempletId: 59L, typeCode: "SPECIAL_SMALL", templetName: "K12教材教辅专项",…}
     * 2: {assistTempletId: 46L, typeCode: "VACATION", templetName: "K12假期作业",…}
     * 3: {assistTempletId: 40L, typeCode: "K12", templetName: "K12试卷",…}
     * 4: {assistTempletId: 65L, typeCode: "TEACHING_NEWSPAPER", templetName: "K12报刊",…}
     * </p>
     */
    public static final Long[] K12_TEMPLATE_IDS = {48L, 59L, 46L, 40L, 65L};
}
