package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;

@Data
public class ProjectFileVO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("项目ID")
    private Integer projectId;

    @ApiModelProperty("文件分类[样章(sample)项目确认书(confirmation)运营方案(operate_plan)印码方案(qrcode_plan)质检报告(quality_report)]，印码设计(qrcode_design)")
    private String fileClass;

    @ApiModelProperty("文件名称")
    private String fileName;

    @ApiModelProperty("文件路径")
    private String fileUrl;

    @ApiModelProperty("文件大小")
    private Long fileSize;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("类型")
    private String typeCode;

    @ApiModelProperty("类型名称")
    private String typeName;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("创建时间")
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    @ApiModelProperty("资源id")
    private Long resourceId;

    @ApiModelProperty("尽调单id")
    private Long orderSheetId;

    @ApiModelProperty("运维任务id")
    private Long taskId;

    @ApiModelProperty("文件")
    private MultipartFile file;
}
