package com.pcloud.book.clock.service;

import com.pcloud.book.clock.dto.BookGroupClockKeywordDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifiers = "bookClockInfoServiceCloud", path = "book/v1.0/bookClockInfoService")
@Api(description = "微信群打卡内部服务")
public interface BookClockInfoService {

    @ApiOperation("获取微信群某一动作动作关键词")
    @RequestMapping(value = "getBookClockKeyword4Clock",method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookGroupClockKeywordDTO>> getBookClockKeyword4Clock(@RequestParam("bookClockInfoId") Long bookClockInfoId,
                                                                                    @RequestParam("operation") String operation) throws BizException;

    @ApiOperation("发送微信群打卡消息")
    @PostMapping("/sendBookClockGroupMessage")
    void sendBookClockGroupMessage(@RequestBody Map<String, Object> map) throws BizException;

    @ApiOperation(value = "处理关联应用的打卡的旧数据", httpMethod = "GET")
    @RequestMapping(value = "/dealOldData4WeixinClock", method = RequestMethod.GET)
    void dealOldData4WeixinClock();

    @ApiOperation(value = "处理关联作品的打卡的旧数据", httpMethod = "GET")
    @RequestMapping(value = "/dealOldData4WeixinAtt", method = RequestMethod.GET)
    void dealOldData4WeixinAtt();
}
