package com.pcloud.book.cultivate.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName com.pcloud.book.cultivate.dto.NotifyItemDTO
 * @Author zhuyajie
 * @Description 消息详情
 * @Date 2021/7/14 14:40
 * @Version 1.0
 **/
@Data
public class NotifyItemDTO {

    @ApiModelProperty("发送内容（1-文本，2-图片，3-音频, 4-链接,5 问题）")
    private Integer contentType;

    @ApiModelProperty("文字内容")
    private String content;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("音频资源id")
    private Long resourceId;

    @ApiModelProperty("跳转类型 1指定页面, 2web页面, 3资讯, 4应用作品")
    private Integer jumpType;

    @ApiModelProperty("跳转地址")
    private String jumpUrl;

    @ApiModelProperty("作品/应用/咨询的ID")
    private Long serveId;

    @ApiModelProperty("作品5/应用6/咨询的类型1")
    private Integer serveType;

    @ApiModelProperty("JSON格式的额外信息")
    private String extJson;

}
