package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletThirdResourcesChooseBiz;
import com.pcloud.book.applet.dto.AppletThirdResourcesStaticDTO;
import com.pcloud.book.applet.entity.AppletThirdResourcesChoose;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.wechatgroup.message.enums.IsSystem;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * (AppletThirdResourcesChoose)表控制层
 *
 * @author makejava
 * @since 2020-10-14 16:22:28
 */
@RestController("appletThirdResourcesChooseFacade")
@RequestMapping("appletThirdResourcesChoose")
public class AppletThirdResourcesChooseFacade {

    @Autowired
    private AppletThirdResourcesChooseBiz appletThirdResourcesChooseBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletThirdResourcesChooseBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletThirdResourcesChooseBiz.getList(currentPage, numPerPage));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token, @RequestBody AppletThirdResourcesChoose appletThirdResourcesChoose)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletThirdResourcesChooseBiz.insert(appletThirdResourcesChoose));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token, @RequestBody AppletThirdResourcesChoose appletThirdResourcesChoose) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        appletThirdResourcesChooseBiz.update(appletThirdResourcesChoose);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        appletThirdResourcesChooseBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("分页查询")
    @GetMapping("getListThirdResourcesStatic")
    public ResponseDto<PageBeanNew<AppletThirdResourcesStaticDTO>> getListThirdResourcesStatic(@RequestHeader("token") String token,
                                                                                               @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                                                                               @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage,
                                                                                               @RequestParam(value = "source", required = false) String source,
                                                                                               @RequestParam(value = "keyValue", required = false) String keyValue,
                                                                                               @RequestParam(value = "queryDate", required = false) String queryDate)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<PageBeanNew<AppletThirdResourcesStaticDTO>>(appletThirdResourcesChooseBiz.getListThirdResourcesStatic(currentPage, numPerPage, source, keyValue, queryDate));
    }

    @ApiOperation("分页查询")
    @GetMapping("exportListThirdResourcesStatic")
    public ResponseDto<?> exportListThirdResourcesStatic(@RequestHeader("token") String token,
                                                                                               @RequestParam(value = "currentPage", required = false, defaultValue = "0") Integer currentPage,
                                                                                               @RequestParam(value = "numPerPage", required = false, defaultValue = "10000") Integer numPerPage,
                                                                                               @RequestParam(value = "source", required = false) String source,
                                                                                               @RequestParam(value = "keyValue", required = false) String keyValue,
                                                                                               @RequestParam(value = "queryDate", required = false) String queryDate)
            throws BizException, PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        String isSystem = (String) map.get(SessionUtil.IS_SYSTEM);
        Long partyId = (Long) map.get(SessionUtil.PARTY_ID);
        if (IsSystem.NOT_SYSTEM.code.equals(isSystem)) {
            partyId = (Long) map.get(SessionUtil.MEMBER_ID);
        }
        appletThirdResourcesChooseBiz.exportListThirdResourcesStatic(currentPage, numPerPage, source, keyValue, queryDate, partyId);
        return new ResponseDto<>();
    }

}