package com.pcloud.book.book.biz;

import com.pcloud.book.book.entity.BookSerialNumber;
import com.pcloud.common.page.PageBeanNew;

/**
 * 序号自动生成表(BookSerialNumber)表服务接口
 *
 * @author makejava
 * @since 2020-08-26 14:04:04
 */
public interface BookSerialNumberBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BookSerialNumber getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @return 主键
     */
    void insert(BookSerialNumber bookSerialNumber);

    /**
     * 修改数据
     *
     * @param bookSerialNumber 实例对象
     */
    void update(BookSerialNumber bookSerialNumber);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    BookSerialNumber getByIsbn(String isbn);
}
