package com.pcloud.book.consumer.book.elasticsearch;

import com.pcloud.book.elasticsearch7.domain.dto.param.PlatformSearchDto;
import com.pcloud.book.elasticsearch7.domain.entity.Es7Book;
import com.pcloud.book.elasticsearch7.service.PlatformBookSearchService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.universe.commons.paging.Pagination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * book elasticsearch
 */
@Component
public class BookElasticSearchConsr {

    /**
     * logger
     */
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private PlatformBookSearchService platformBookSearchService;

    public Pagination<Es7Book> search(PlatformSearchDto dto) {
        try {
            ResponseDto<Pagination<Es7Book>> r = platformBookSearchService.search(dto);
            return r.getData();
        } catch (Exception e) {
            logger.error("platform book es search exception.", e);
        }
        return new Pagination<>();
    }
}
