package com.pcloud.book.copyright.biz;

import com.pcloud.book.copyright.dto.BookAuthCodeDTO;
import com.pcloud.book.copyright.dto.DeleteAuthCodeDTO;
import com.pcloud.book.copyright.entity.BookAuthCode;
import com.pcloud.book.copyright.vo.CheckCodeParam;
import com.pcloud.book.copyright.vo.CheckIsAuthServeParam;
import com.pcloud.book.copyright.vo.FileVO;
import com.pcloud.book.copyright.vo.ImportRecordVO;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 19:11
 */
public interface BookAuthCodeBiz {

    /**
     * 批量插入授权码
     * @param bookAuthCodes
     */
    void insert(List<BookAuthCode> bookAuthCodes);

    /**
     *  获取最大批次号
     */
    Integer getMaxBatchNum(Long bookId, Long channelId, Long adviserId, Integer authBookType);

    /**
     *  校验验证码
     */
    Integer checkCode(CheckCodeParam checkCodeParam, Long channelId, Long wechatUserId);

    /**
     * 校验该服务是否需要校验
     * @return
     */
    Boolean checkServe(CheckIsAuthServeParam checkIsAuthServeParam, Long channelId, Long wechatUserId);

    /**
     * @Author:lili
     * @Desr:授权码导入
     * @Date:2019/5/20 15:12
     */
    void importCode(FileVO fileVO, Long adviserId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取导入记录
     * @Date:2019/5/22 18:02
     */
    PageBeanNew<ImportRecordVO> importCodeRecord(Long bookId, Long channelId, Long adviserId, Integer authBookType, Integer currentPage, Integer numPerPage);

    /**
     * 获取正版授权码
     * @param bookId
     * @param channelId
     * @param keyword
     * @param state
     * @param pageParam
     * @return
     */
    PageBeanNew<BookAuthCodeDTO> getCodeList(Long bookId, Long channelId, Long adviserId, String keyword, Integer state, Integer authBookType, PageParam pageParam);

    /**
     * 批量删除正版授权码
     * @param ids
     */
    void batchDeleteCode(List<Long> ids);

    /**
     * 导出授权码
     * @param bookId
     * @param codeIds
     * @param channelId
     * @param status
     * @param systemCode
     * @param partyId
     * @return
     */
    Map<String, Object> getCodeExcel(Long bookId, String codeIds, Long channelId, Long status, String systemCode, Long partyId, Integer authBookType);

    /**
     * 一键清空未使用的授权码
     */
    void deleteNoUsedAuthCode(DeleteAuthCodeDTO deleteAuthCodeDTO, Long adviserId);
}
