package com.pcloud.book.es.facade.impl;

import cn.hutool.core.util.StrUtil;
import com.pcloud.book.es.biz.ESBookGroupQrcodeBiz;
import com.pcloud.book.es.dto.GroupQrcodeSearchDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController("esBookGroupQrcodeFacade")
@RequestMapping("esBookGroupQrcode")
@Api(description = "book_group_qrcode ES 外部接口")
public class ESBookGroupQrcodeFacadeImpl {

    @Autowired
    private ESBookGroupQrcodeBiz esBookGroupQrcodeBiz;

    @ApiOperation("初始化数据")
    @RequestMapping(value = "init",method = RequestMethod.GET)
    public ResponseDto<?> initData(){
        return new ResponseDto<>();
    }

    @ApiOperation(value = "搜索群 标签/群名称", httpMethod = "GET")
    @RequestMapping(value = "/search", method = RequestMethod.GET)
    public ResponseDto<PageBeanNew<GroupQrcodeSearchDTO>> search(@RequestParam(value = "keyword", required = false) String keyword,
                                                                 @RequestParam(value = "methodType",required = false) String methodType,
                                                                 @RequestParam(value = "isOrder",required = false) Boolean isOrder,
                                                                 @RequestParam("numPerPage") Integer numPerPage,
                                                                 @RequestParam("currentPage") Integer currentPage) {
        if (StrUtil.isBlank(methodType)){
            methodType = "OR";
        }
        return new ResponseDto<>(esBookGroupQrcodeBiz.search(keyword, methodType, isOrder,numPerPage, currentPage));
    }

}
