package com.pcloud.book.es.service.impl;

import com.pcloud.book.es.biz.ESBookGroupQrcodeBiz;
import com.pcloud.book.es.dto.ESBookGroupQrcodeDTO;
import com.pcloud.book.es.service.ESBookGroupQrcodeService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController("esBookGroupQrcodeService")
@RequestMapping("esBookGroupQrcodeService")
public class ESBookGroupQrcodeServiceImpl implements ESBookGroupQrcodeService {

    @Autowired
    private ESBookGroupQrcodeBiz esBookGroupQrcodeBiz;


    @Override
    @ApiOperation("通过微信群ID(xxx@chatroom)获取ES中的群信息")
    @RequestMapping(value = "searchByWxGroupIds", method = RequestMethod.GET)
    public List<ESBookGroupQrcodeDTO> searchByWxGroupIds(@RequestParam("wxGroupIds") List<String> wxGroupIds) {
        return esBookGroupQrcodeBiz.searchByWxGroupIds(wxGroupIds);
    }

    @Override
    @ApiOperation("更新ES中的群信息")
    @RequestMapping(value = "save", method = RequestMethod.POST)
    public void save(@RequestBody List<ESBookGroupQrcodeDTO> dtos) {
        esBookGroupQrcodeBiz.save(dtos);
    }
}
