package com.pcloud.book.advertising.entity;

import java.util.Date;
import java.util.List;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.common.entity.BaseEntity;

/**
 * @author PENG
 */
public class AdvertisingDistributionBook extends BaseEntity {

    private static final long serialVersionUID = -7658299195342462203L;

    /**
     * advertising_distribution_book.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_distribution_book.ad_id (广告位ID)
     */
    private Long adId;

    /**
     * advertising_distribution_book.book_id (书刊ID)
     */
    private Long bookId;

    /**
     * advertising_distribution_book.adviser_id (编辑ID)
     */
    private Long adviserId;

    /**
     * advertising_distribution_book.agent_id (出版ID)
     */
    private Long agentId;

    /**
     * advertising_distribution_book.channel_id (运营ID)
     */
    private Long channelId;

    /**
     * advertising_distribution_book.distribution_time (投放时间)
     */
    private Date distributionTime;

    /**
     * 书刊ID列表
     */
    private List<BookAdviser> books;

    /**
     * 投放方式（0：指定书刊；1：不指定书刊）
     */
    private Integer distributionType;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Date getDistributionTime() {
        return distributionTime;
    }

    public void setDistributionTime(Date distributionTime) {
        this.distributionTime = distributionTime;
    }

    public List<BookAdviser> getBooks() {
        return books;
    }

    public void setBooks(List<BookAdviser> books) {
        this.books = books;
    }

    public Integer getDistributionType() {
        return distributionType;
    }

    public void setDistributionType(Integer distributionType) {
        this.distributionType = distributionType;
    }

    @Override
    public String toString() {
        return "AdvertisingDistributionBook{" +
                "id=" + id +
                ", adId=" + adId +
                ", bookId=" + bookId +
                ", adviserId=" + adviserId +
                ", agentId=" + agentId +
                ", channelId=" + channelId +
                ", distributionTime=" + distributionTime +
                ", books=" + books +
                ", distributionType=" + distributionType +
                "} " + super.toString();
    }
}