package com.pcloud.book.copyright.biz;

import com.pcloud.book.copyright.entity.BookAuthCode;
import com.pcloud.book.copyright.vo.CheckCodeParam;
import com.pcloud.book.copyright.vo.CheckIsAuthServeParam;

import java.util.List;

/**
 * @author lily
 * @date 2018/12/4 19:11
 */
public interface BookAuthCodeBiz {

    /**
     * 批量插入授权码
     * @param bookAuthCodes
     */
    void insert(List<BookAuthCode> bookAuthCodes);

    /**
     *  获取最大批次号
     */
    Integer getMaxBatchNum(Long bookId, Long channelId, Long adviserId);

    /**
     *  校验验证码
     */
    Integer checkCode(CheckCodeParam checkCodeParam, Long channelId, Long wechatUserId);

    /**
     * 校验该服务是否需要校验
     * @return
     */
    Boolean checkServe(CheckIsAuthServeParam checkIsAuthServeParam, Long channelId, Long wechatUserId);
}
