package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.GroupQrcodeDao;
import com.pcloud.book.group.dto.ChangeGroupNameDTO;
import com.pcloud.book.group.dto.GroupAndUserNumberDTO;
import com.pcloud.book.group.dto.GroupQrcodeDTO;
import com.pcloud.book.group.dto.GroupQrcodeInfoDTO;
import com.pcloud.book.group.dto.UpdateQrDTO;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.book.group.vo.GroupQrcodeBaseInfoVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/17 16:38
 */
@Component("groupQrcodeDao")
public class GroupQrcodeDaoImpl extends BaseDaoImpl<GroupQrcode> implements GroupQrcodeDao {
    @Override
    public void deleteByClassifyId(Long classifyId) {
        this.getSqlSession().update(this.getStatement("deleteByClassifyId"), classifyId);
    }

    @Override
    public Map<Long, GroupAndUserNumberDTO> listGroupAndUserNumber(List<Long> classifyIds) {
        return  this.getSqlSession().selectMap(this.getStatement("listGroupAndUserNumber"), classifyIds, "classifyId");

    }

    @Override
    public void modifyNameById(String wechatGroupName, Long id, Long updateUser) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("wechatGroupName", wechatGroupName);
        paramMap.put("updateUser", updateUser);
        this.getSqlSession().update(this.getStatement("modifyNameById"), paramMap);
    }

    @Override
    public void updateQrUrl(UpdateQrDTO updateQrDTO) {
        this.getSqlSession().update(this.getStatement("updateQrUrl"), updateQrDTO);
    }

    @Override
    public List<ChangeGroupNameDTO> getWechatGroupInfo(List<Long> ids) {
        return this.getSqlSession().selectList(this.getStatement("getWechatGroupInfo"), ids);
    }

    @Override
    public void syncWeixinGroupId(Long weixinQrcodeId, String weixinGroupId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("weixinQrcodeId", weixinQrcodeId);
        paramMap.put("weixinGroupId", weixinGroupId);
        this.getSqlSession().update(this.getStatement("syncWeixinGroupId"), paramMap);
    }

    @Override
    public void updateUserNumber(String wechatGroupId, Integer memberCount) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("memberCount", memberCount);
        paramMap.put("weixinGroupId", wechatGroupId);
        this.getSqlSession().update(this.getStatement("updateUserNumber"), paramMap);
    }

    @Override
    public GroupQrcodeDTO getGroupQrcodeInfo(String weixinGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getGroupQrcodeInfo"), weixinGroupId);

    }

    @Override
    public void updateUseState(Long id, Integer useState) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("useState", useState);
        this.getSqlSession().update(this.getStatement("updateUseState"), paramMap);
    }

    @Override
    public void changeQrcodeState(Long id, Integer qrcodeState) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("qrcodeState", qrcodeState);
        this.getSqlSession().update(this.getStatement("changeQrcodeState"), paramMap);
    }

    @Override
    public Map<Long, GroupQrcodeInfoDTO> listQrcodeInfoByIds(List<Long> groupQrcodeIds) {
        return this.getSqlSession().selectMap(this.getStatement("listQrcodeInfoByIds"), groupQrcodeIds, "id");
    }

    @Override
    public GroupQrcodeBaseInfoVO getBaseById(Long groupQrcodeId) {
        return this.getSqlSession().selectOne(this.getStatement("getBaseById"), groupQrcodeId);
    }

    @Override
    public ChangeGroupNameDTO getUpdateGroupNameParam(Long id) {
        return this.getSqlSession().selectOne(this.getStatement("getUpdateGroupNameParam"), id);
    }
}
