package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;

/**
 * @author lily
 * @date 2019/4/17 14:17
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ClassifyDTO implements Serializable {

    /**
     * 群标签标识
     */
    private Long id;

    /**
     * 图书标识
     */
    private Long bookId;

    /**
     * 运营标识
     */
    private Long channelId;

    /**
     * 社群二维码标识
     */
    private Long bookGroupId;

    /**
     * 分类
     */
    private String classify;

    /**
     * 分类介绍
     */
    private String classifyIntroduce;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 商品标识
     */
    private Long productId;

    /**
     * 规格标识
     */
    private Long productSpecId;

    /**
     * 换群人数
     */
    private Integer changeNumber;

    /**
     * 排序
     */
    private Integer rank;

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getClassifyIntroduce() {
        return classifyIntroduce;
    }

    public void setClassifyIntroduce(String classifyIntroduce) {
        this.classifyIntroduce = classifyIntroduce;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getChangeNumber() {
        return changeNumber;
    }

    public void setChangeNumber(Integer changeNumber) {
        this.changeNumber = changeNumber;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getProductSpecId() {
        return productSpecId;
    }

    public void setProductSpecId(Long productSpecId) {
        this.productSpecId = productSpecId;
    }

    @Override
    public String toString() {
        return "ClassifyDTO{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", bookGroupId=" + bookGroupId +
                ", classify='" + classify + '\'' +
                ", classifyIntroduce='" + classifyIntroduce + '\'' +
                ", price=" + price +
                ", productId=" + productId +
                ", productSpecId=" + productSpecId +
                ", changeNumber=" + changeNumber +
                ", rank=" + rank +
                '}';
    }
}
