package com.pcloud.book.keywords.dao.impl;

import com.pcloud.book.keywords.dao.BookGuideReplyDao;
import com.pcloud.book.keywords.entity.BookGuideReply;
import com.pcloud.book.keywords.vo.ReplyMessageVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/23 16:06
 */
@Component("bookGuideReplyDao")
public class BookGuideReplyDaoImpl extends BaseDaoImpl<BookGuideReply> implements BookGuideReplyDao {

    @Override
    public void deleteByGuideId(Long bookGuideId) {
        this.getSqlSession().update("deleteByGuideId", bookGuideId);
    }

    @Override
    public List<ReplyMessageVO> getReplyMessage(Long guideId) {
        return this.getSqlSession().selectList("getReplyMessage", guideId);
    }
}
