package com.pcloud.book.keywords.facade.impl;

import com.pcloud.book.keywords.biz.BookKeywordBiz;
import com.pcloud.book.keywords.facade.BookKeywordFacade;
import com.pcloud.book.keywords.vo.KeywordVO;
import com.pcloud.book.keywords.vo.ListKeywordParam;
import com.pcloud.book.keywords.vo.ListKeywordVO;
import com.pcloud.book.keywords.vo.SetKeywordVO;
import com.pcloud.book.keywords.vo.SetRankVO;
import com.pcloud.book.keywords.vo.UpdateKeywordVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lily
 * @date 2019/4/24 14:31
 */
@RestController("bookKeywordFacade")
@RequestMapping("bookKeyword")
public class BookKeywordFacadeImpl implements BookKeywordFacade {
    @Autowired
    private BookKeywordBiz bookKeywordBiz;

    @Override
    @PostMapping("insertKeyword")
    public ResponseDto<?> insertKeyword(@RequestHeader("token") String token, @RequestBody SetKeywordVO setKeywordVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookKeywordBiz.insertKeyword(setKeywordVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateKeyword")
    public ResponseDto<?> updateKeyword(@RequestHeader("token") String token, @RequestBody UpdateKeywordVO updateKeywordVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookKeywordBiz.updateKeyword(updateKeywordVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("deleteKeyword")
    public ResponseDto<?> deleteKeyword(@RequestHeader("token") String token, @RequestParam("keywordId") Long keywordId) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookKeywordBiz.deleteKeyword(keywordId, partyId);
        return new ResponseDto<>();
    }


    @Override
    @GetMapping("getByBookKeyword")
    public ResponseDto<KeywordVO> getByBookKeyword(@RequestHeader("token") String token, @RequestParam("bookKeywordId") Long bookKeywordId) throws BizException, PermissionException {
        KeywordVO keywordVO = bookKeywordBiz.getByBookKeyword(bookKeywordId);
        return new ResponseDto<>(keywordVO);
    }

    @Override
    @PostMapping("setRank")
    public ResponseDto<?> setRank(@RequestHeader("token") String token, @RequestBody SetRankVO setRankVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookKeywordBiz.setRank(setRankVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("listKeywordsByBookGroup")
    public ResponseDto<PageBeanNew<ListKeywordVO>> listKeywordsByBookGroup(@RequestHeader("token") String token, @RequestBody ListKeywordParam listKeywordParam) throws BizException {
        listKeywordParam.setClassifyId(0L);
        PageBeanNew<ListKeywordVO> pageBeanNew = bookKeywordBiz.listKeywordsByClassify(listKeywordParam);
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @PostMapping("listKeywordsByClassify")
    public ResponseDto<PageBeanNew<ListKeywordVO>> listKeywordsByClassify(@RequestHeader("token") String token, @RequestBody ListKeywordParam listKeywordParam) throws BizException {
        PageBeanNew<ListKeywordVO> pageBeanNew = bookKeywordBiz.listKeywordsByClassify(listKeywordParam);
        return new ResponseDto<>(pageBeanNew);
    }
}
