package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/29 10:03
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListClassify4WechatDTO implements Serializable {

    @ApiModelProperty("分类标识")
    private Long classifyId;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("社群码标识")
    private Long bookGroupId;

    @ApiModelProperty("分类")
    private String classify;

    @ApiModelProperty("分类介绍")
    private String classifyIntroduce;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("商品标识")
    private Long productId;

    @ApiModelProperty("规格标识")
    private Long productSpecId;

    @ApiModelProperty("群人数限制")
    private Integer changeNumber;

    @ApiModelProperty("分群数")
    private Integer groupSeq;

    @ApiModelProperty("用户数量")
    private Integer userNumber;

    @ApiModelProperty("用户头像")
    private List<String> headUrl;

    @ApiModelProperty("群二维码标识")
    private Long groupQrcodeId;

    @ApiModelProperty("是否购买")
    private Boolean isBuy = false;

    public Boolean getBuy() {
        return isBuy;
    }

    public void setBuy(Boolean buy) {
        isBuy = buy;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getProductSpecId() {
        return productSpecId;
    }

    public void setProductSpecId(Long productSpecId) {
        this.productSpecId = productSpecId;
    }

    public Long getGroupQrcodeId() {
        return groupQrcodeId;
    }

    public void setGroupQrcodeId(Long groupQrcodeId) {
        this.groupQrcodeId = groupQrcodeId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getClassifyIntroduce() {
        return classifyIntroduce;
    }

    public void setClassifyIntroduce(String classifyIntroduce) {
        this.classifyIntroduce = classifyIntroduce;
    }

    public Integer getChangeNumber() {
        return changeNumber;
    }

    public void setChangeNumber(Integer changeNumber) {
        this.changeNumber = changeNumber;
    }

    public Integer getGroupSeq() {
        return groupSeq;
    }

    public void setGroupSeq(Integer groupSeq) {
        this.groupSeq = groupSeq;
    }

    public Integer getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public List<String> getHeadUrl() {
        return headUrl;
    }

    public void setHeadUrl(List<String> headUrl) {
        this.headUrl = headUrl;
    }

    @Override
    public String toString() {
        return "ListClassify4WechatVO{" +
                "classifyId=" + classifyId +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", bookGroupId=" + bookGroupId +
                ", classify='" + classify + '\'' +
                ", classifyIntroduce='" + classifyIntroduce + '\'' +
                ", price=" + price +
                ", productId=" + productId +
                ", productSpecId=" + productSpecId +
                ", changeNumber=" + changeNumber +
                ", groupSeq=" + groupSeq +
                ", userNumber=" + userNumber +
                ", headUrl=" + headUrl +
                ", groupQrcodeId=" + groupQrcodeId +
                ", isBuy=" + isBuy +
                '}';
    }
}
