package com.pcloud.book.group.service;


import com.pcloud.book.group.dto.AddBookGroupServeDTO;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.BookGroupServiceDTO;
import com.pcloud.book.group.dto.CreateDefaultResourcePageDTO;
import com.pcloud.book.group.dto.CreateGroupDTO;
import com.pcloud.book.group.dto.MessagServeDTO;
import com.pcloud.common.dto.ResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiOperation;

@FeignClient(value = "pcloud-service-book", qualifiers = "BookGroupDataCloud", path = "book/v1.0/bookGroupDataService")
public interface BookGroupDataService {

    @RequestMapping(value = "/getBookGroupService", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, List<BookGroupServiceDTO>>>> getBookGroupService(@RequestBody List<Long> bookGroupIds);

    @RequestMapping(value = "/createBookGroup", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<BookGroupDTO>> createBookGroup(@RequestBody CreateGroupDTO createGroupDTO);
    @RequestMapping(value = "/AddBookGroupServe", method = RequestMethod.POST)
    void AddBookGroupServe(@RequestBody List<AddBookGroupServeDTO> list, @RequestParam("partyId")Long partyId);

    @ApiOperation("批量更新bookgroup对应的sceneId")
    @PostMapping("batchUpdateSceneIdByBookGroup")
    void batchUpdateSceneIdByBookGroup(@RequestBody List<AddBookGroupServeDTO> list);

    @ApiOperation("RAYS码创建默认资源页")
    @PostMapping("createDefaultResourcePage")
    void createDefaultResourcePage(@RequestBody CreateDefaultResourcePageDTO createDefaultResourcePageDTO);

    @ApiOperation("二维码需要同步到channel的资源")
    @GetMapping("getServeListBySceneId4QrUpdate")
    ResponseEntity<ResponseDto<List<MessagServeDTO>>> getServeListBySceneId4QrUpdate(@RequestParam("sceneId") Long sceneId);
}
