package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.entity.AdvertisingGroupTag;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @描述：群标记广告主
 * @作者：zhuyajie
 * @创建时间：14:52 2019/8/21
 * @版本：1.0
 */
public interface AdvertisingGroupTagDao extends BaseDao<AdvertisingGroupTag> {

    /**
     * 根据品牌方删除
     * @param brandId
     */
    public void deleteByBrandId(Long brandId);

    /**
     * 已标记的书
     * @param brandId
     * @return
     */
    public List<Long> getBookIdsByBrandId(Long brandId);

    /**
     * 根据群删除标记
     * @param groupQrcodeId
     */
    public void deleteByGroupQrcodeId(Long groupQrcodeId);

    /**
     * 已标记的群
     * @param brandId
     * @return
     */
    public List<Long> getGroupQrcodeIdsByBrandId(Long brandId);

    /**
     * 根据图书删除标记
     * @param bookIds
     * @param brandId
     */
    void deleteByBook(List<Long> bookIds, Long brandId);

    /**
     * 查已标记的微信群id
     * @param brandId
     * @return
     */
    List<String> getTagWxGroupIdsByBrandId(Long brandId);

    /**
     * 根据书查标记的品牌方
     * @param bookId
     * @return
     */
    List<Long> getBrandIdsByBookId(Long bookId);

    /**
     * 查微信群标记的品牌方id
     * @param wxGroupId
     * @return
     */
    List<Long> getBrandIdsByWxGroupId(String wxGroupId);

    /**
     * 更新旧数据品牌id
     * @param masterId
     * @param brandId
     */
    void updateId(Long masterId, Long brandId);
}
