package com.pcloud.book.advertising.enums;

/**
 * @描述：广告详情介绍方式
 * @作者：zhuyajie
 * @创建时间：14:37 2019/6/25
 * @版本：1.0
 */
public enum AdDetailModeEnum {

    IMG_TEXT("IMG_TEXT","图文介绍"),
    AUDIO("AUDIO","音频试听"),
    DEDICATED_LINK("DEDICATED_LINK","专链路"),
    VIDEO("VIDEO","视频试看");

    public final String code;

    public final String name;

    AdDetailModeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(String code) {
        AdDetailModeEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdDetailModeEnum methodEnum = var1[var3];
            if (methodEnum.code.equals(code)) {
                return methodEnum.name;
            }
        }
        return null;
    }
}
