package com.pcloud.book.advertising.facade.impl;

import com.pcloud.book.advertising.biz.BmBiz;
import com.pcloud.book.advertising.entity.AdvertisingBmRegister;
import com.pcloud.book.advertising.facade.BmFacade;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import com.pcloud.common.utils.string.StringUtil;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 报名
 */
@RestController("bmFacade")
@RequestMapping("/bm")
public class BmFacadeImpl implements BmFacade {

	@Autowired
	private BmBiz bmBiz;


	/**
	 * 获取选项类型
	 */
	@Override
	@RequestMapping(value = "getOptionType",method = RequestMethod.GET)
	public ResponseDto<?> getOptionType(@RequestHeader("token") String token)
			throws PermissionException, BizException, JsonParseException {
		SessionUtil.getToken4Redis(token);
		return new ResponseDto<>(bmBiz.getOptionType());
	}
	/**
	 * 获取选项数据类型
	 */
	@RequestMapping(value = "/getOptionDataType",method = RequestMethod.GET)
	@Override
	public ResponseDto<?> getOptionDataType(@RequestHeader("token") String token)
			throws PermissionException, BizException, JsonParseException {
		SessionUtil.getToken4Redis(token);
		return new ResponseDto<>(bmBiz.getOptionDataType());
	}

	/**
	 * 用户提交表单
	 */
	@Override
	@RequestMapping(value = "/userSubmit4Wechat",method = RequestMethod.POST)
	public ResponseDto<?> userSubmit4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody AdvertisingBmRegister bmRegister)
			throws PermissionException, BizException, JsonParseException {
		if (null == bmRegister || (null == bmRegister.getAdId() && null==bmRegister.getCpaId())) {
			throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数有误！");
		}
		if(null!=bmRegister.getAdId()) {
			if (StringUtil.isEmpty(bmRegister.getFromType()) || null == bmRegister.getFromId()) {
				throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数有误！");
			}
		}
		Long qrcodeId = Cookie.getId(userInfo, Cookie.QRCODE_ID);
		Long sceneId = Cookie.getId(userInfo, Cookie._SCENE_ID);
		Long adviserId = Cookie.getId(userInfo, Cookie._ADVISER_ID);
		Long channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
		Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
		Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
		Long bookGroupId = Cookie.getId(userInfo, Cookie.BOOK_GROUP_ID);
		if(null!=bmRegister.getAdId()) {
			if ((null == bmRegister.getBookId() && !"WECHAT_GROUP".equals(bmRegister.getFromType()))
					|| (null == bookGroupId && "WECHAT_GROUP".equals(bmRegister.getFromType()))) {
				throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数有误！");
			}
		}
		bmRegister.setQrcodeId(qrcodeId);
		bmRegister.setSceneId(sceneId);
		bmRegister.setAdviserId(adviserId);
		bmRegister.setChannelId(channelId);
		bmRegister.setOfficialAccountId(officialAccountsId);
		bmRegister.setUserId(wechatUserId);
		bmRegister.setBookGroupId(bookGroupId);
		Long result = null;
		if(null!=bmRegister.getAdId()){
			result=bmBiz.userSubmit(bmRegister, wechatUserId);
		}
		if(null!=bmRegister.getCpaId()){
			result=bmBiz.userSubmit4Cpa(bmRegister, wechatUserId);
		}
		return new ResponseDto<>(result);
	}

	/**
	 * 微信端获取个人报名详情
	 */
	@Override
	@RequestMapping(value = "/getDetail4Wechat",method = RequestMethod.GET)
	public ResponseDto<?> getDetail4Wechat(@CookieValue("userInfo") String userInfo,
										   @RequestParam(value = "adId",required = false) Long adId,
										   @RequestParam(value = "cpaId",required = false) Long cpaId)
			throws PermissionException, BizException, JsonParseException {
		Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
		Long qrcodeId = Cookie.getId(userInfo, Cookie.QRCODE_ID);
		if ((null == adId && null==cpaId)) {
			throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数有误！");
		}
		return new ResponseDto<>(bmBiz.getDetail4Wechat(adId, wechatUserId,qrcodeId,cpaId));
	}

	/**
	 * 报名信息导出
	 */
	@Override
	@RequestMapping(value = "/exportRegisterInfoByAdId", method = RequestMethod.GET)
	public ResponseDto<Map<String, Object>> exportRegisterInfoByAdId(
			@RequestHeader("token") String token, @RequestParam("adId") Long adId,
			@RequestParam(value = "qrcodeId", required = false) Long qrcodeId,
			@RequestParam(value = "statisMonth", required = false) String statisMonth,
			@RequestParam(value = "bookId", required = false) Long bookId, @RequestParam(value = "adviserId", required = false) Long adviserId,
			@RequestParam(value = "channelId", required = false) Long channelId) throws PermissionException, BizException, JsonParseException {
		if (null == adId) {
			throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数有误！");
		}
		SessionUtil.getInfoToken4Redis(token);
		Map<String, Object> map = bmBiz.exportRegisterInfoByAdId(adId, qrcodeId, statisMonth, bookId, adviserId, channelId);
		return new ResponseDto<>(map);
	}

	/**
	 * cpa内容管理报名信息导出
	 */
	@RequestMapping(value = "/exportRegisterInfoByCpaId", method = RequestMethod.GET)
	public ResponseDto<Map<String, Object>> exportRegisterInfoByCpaId(
			@RequestHeader("token") String token, @RequestParam("cpaId") Long cpaId,
			@RequestParam(value = "statisMonth", required = false) String statisMonth) throws PermissionException, BizException, JsonParseException {
		if (null == cpaId) {
			throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数有误！");
		}
		SessionUtil.getInfoToken4Redis(token);
		Map<String, Object> map = bmBiz.exportRegisterInfoByCpaId(cpaId, statisMonth);
		return new ResponseDto<>(map);
	}

}
