package com.pcloud.book.applet.biz;

import com.pcloud.appcenter.assist.dto.AssistTempletDTO;
import com.pcloud.book.applet.dto.AppletBookClassifyDTO;
import com.pcloud.book.applet.dto.AppletBookClassifyRelationDTO;
import com.pcloud.book.applet.dto.AppletUserLabelDTO;
import com.pcloud.book.applet.entity.AppletBookClassify;
import com.pcloud.book.applet.entity.AppletBookClassifyAgent;
import com.pcloud.book.applet.entity.AppletUserLabelRelation;

import java.util.List;
import java.util.Map;

/**
 * 小程序书刊分类
 * @author：zhuyajie
 * @date：2020/5/15 16:30
 *  * @param null
 */
public interface AppletBookClassifyBiz {

    /**
     * 书刊分类查询
     * @author：zhuyajie
     * @date：2020/5/15 16:31
     *  * @param null
     */
    List<AppletBookClassifyDTO> getAppletBookClassifyList(Boolean showState);

    /**
     * 根据id查询
     * @author：zhuyajie
     * @date：2020/5/15 16:32
     *  * @param null
     */
    AppletBookClassifyDTO getById(Long id);
    /**
     * 修改书刊分类
     * @author：zhuyajie
     * @date：2020/5/15 16:33
     *  * @param null
     */
    void update(AppletBookClassify appletBookClassify);

    /**
     * 平台端新增客户端标签
     * @param appletUserLabelDTO
     */
    void addUserLabel(AppletUserLabelDTO appletUserLabelDTO);

    /**
     * 关联书刊一级分类
     * @author：zhuyajie
     * @date：2020/5/18 13:59
     *  * @param null
     */
    void addBookTempletRelation(List<Long> templetIdList, Long bookClassifyId);
    /**
     * 根据小程序书刊分类id查书刊一级分类
     * @author：zhuyajie
     * @date：2020/5/18
     *  * @param null
     */
    List<AppletBookClassifyRelationDTO> getRelationBookTempletByBookClassifyId(Long bookClassifyId);

    /**
     * 更新客户端标签
     * @param appletUserLabelDTO
     */
    void updateUserLabel(AppletUserLabelDTO appletUserLabelDTO);

    /**
     * 删除客户端标签
     * @param id
     */
    void deleteUserLabel(Long id);

    /**
     * 平台端设置的客户端标签列表
     * @param appletBookClassifyId
     * @return
     */
    List<AppletUserLabelDTO> listUserLabel(Long appletBookClassifyId, Long agentId);
    /**
     * 获取书刊分类列表及其标签
     * @author：zhuyajie
     * @date：2020/5/18 16:14
     *  * @param null
     */
    List<AppletBookClassifyDTO> getAllBookClassifyAndLabel4Wechat(String grayStatus, Long officialAccountsId);

    /**
     * 查关联书刊分类
     * @author：zhuyajie
     * @date：2020/5/19 18:38
     *  * @param null
     */
    List<Long> getRelationBookTempletByBookClassify(Long bookClassifyId);

    /**
     * 查关联标签
     * @author：zhuyajie
     * @date：2020/5/19 18:38
     *  * @param null
     */
    List<AppletUserLabelRelation> getByAppletUserLabelId(Long appletUserLabelId);

    /**
     * 平台端获取二级分类
     * @author：zhuyajie
     * @date：2020/6/15 16:07
     *  * @param null
     */
    List<AssistTempletDTO> getChildTempletList(Long appletBookClassifyId);


    /**
     * 根据一级分类id获取书籍分类id
     * @param firstClassifyId
     * @return
     */
    Long getAppletBookClassifyId(Long firstClassifyId);

    Map<Long, AppletBookClassifyDTO> getBookClassifyByIds(List<Long> bookAdviserIds);
    /**
     * 给出版分配小睿基本书刊分类
     * @author：zhuyajie
     * @date：2020/7/17 17:01
     *  * @param null
     */
    void createBaseClassifysToAgent(Long agentId);

    /**
     * 出版社修改客户端分类展示状态、名称
     * @author：zhuyajie
     * @date：2020/7/17 17:10
     *  * @param null
     */
    void updateBaseInfoByAgent(AppletBookClassifyAgent appletBookClassifyAgent);

    /**
     * 小睿出版管理端书刊分类查询
     * @author：zhuyajie
     * @date：2020/7/17 19:10
     *  * @param null
     */
    List<AppletBookClassifyDTO> getAppletBookClassifyListByAgent(Long agentId, Boolean showState);

    /**
     * 客户端书刊分类查询
     * @author：zhuyajie
     * @date：2020/7/20 9:46
     *  * @param null
     */
    List<AppletBookClassifyDTO> getAppletBookClassifyList4Wechat(Long officialAccountsId, Boolean showState);

    /**
     * 客户端标签列表
     * @author：zhuyajie
     * @date：2020/7/22 15:27
     *  * @param null
     */
    List<AppletUserLabelDTO> listUserLabel4Wechat(Long appletBookClassifyId, Long officialAccountsId);
}
