package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletSubscribeRecordBiz;
import com.pcloud.book.applet.entity.AppletSubscribeRecord;
import com.pcloud.book.applet.enums.SubscribeCountTypeEnum;
import com.pcloud.book.applet.enums.SubscribeRecordTypeEnum;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * (AppletSubscribeRecord)表控制层
 *
 * @author wubo
 * @since 2021-08-03 09:37:01
 */
@RestController("appletSubscribeRecordFacade")
@RequestMapping("appletSubscribeRecord")
public class AppletSubscribeRecordFacade {

    @Autowired
    private AppletSubscribeRecordBiz appletSubscribeRecordBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@CookieValue("userInfo") String userInfo,
                                  @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletSubscribeRecordBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@CookieValue("userInfo") String userInfo,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletSubscribeRecordBiz.getList(currentPage, numPerPage));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@CookieValue("userInfo") String userInfo,
                                 @RequestBody AppletSubscribeRecord appletSubscribeRecord)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        appletSubscribeRecord.setWechatUserId(wechatUserId);
        appletSubscribeRecord.setCountType(SubscribeCountTypeEnum.ADD_SUBSCRIBE.value);
        return new ResponseDto<>(appletSubscribeRecordBiz.insert(appletSubscribeRecord));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@CookieValue("userInfo") String userInfo,
                                 @RequestBody AppletSubscribeRecord appletSubscribeRecord) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        appletSubscribeRecordBiz.update(appletSubscribeRecord);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@CookieValue("userInfo") String userInfo,
                                     @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        appletSubscribeRecordBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("软删除")
    @GetMapping("softDeleteById")
    public ResponseDto<?> softDeleteById(@CookieValue("userInfo") String userInfo,
                                         @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        appletSubscribeRecordBiz.softDeleteById(id);
        return new ResponseDto<>();
    }

}