package com.pcloud.book.book.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.pcloud.book.book.dto.BookFundInfoDto;
import org.springframework.stereotype.Repository;

import com.pcloud.book.book.dao.BookFundDao;
import com.pcloud.book.book.dto.BookFundDto;
import com.pcloud.book.book.entity.BookFund;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * @描述：书刊基金数据访问层实现类
 * @作者：lihao
 * @创建时间：2017年7月14日,下午2:58:15 @版本：1.0
 */
@Repository("bookFundDao")
public class BookFundDaoImpl extends BaseDaoImpl<BookFund> implements BookFundDao {

	/**
	 * 根据书籍ID获取书刊基金
	 */
	@Override
	public List<BookFundDto> getByBookId(Long bookId) {
		return super.getSqlSession().selectList(this.getStatement("getByBookId"), bookId);
	}

	/**
	 * 修改基金获取不包含自己的基金列表
	 */
	@Override
	public List<BookFundDto> getFundListByMap(Map<String, Object> paramMap) {
		return super.getSqlSession().selectList(this.getStatement("getFundListByMap"), paramMap);
	}

	/**
	 * 根据bookIds查询书刊基金关联信息
	 */
	@Override
	public Map<Long, BookFundDto> getByBookIds(List<Long> bookIds) {
		return super.getSqlSession().selectMap(this.getStatement("getByBookIds"), bookIds, "bookId");
	}

	/**
	 * 根据参数查询书刊基金信息
	 */
	@Override
	public List<BookFundDto> getByParamMap(Map<String, Object> paramMap) {
		return super.getSqlSession().selectList(this.getStatement("getByParamMap"), paramMap);
	}

	/**
	 * 批量获取书刊基金总额
	 */
	@Override
	public Map<Long, BookFundDto> getBookFundMoney(List<Long> bookIds) {
		return super.getSqlSession().selectMap(this.getStatement("getBookFundMoney"), bookIds, "bookId");
	}

	/**
	 * //获取当前书刊基金状态
	 */
	@Override
	public List<BookFundDto> getCurrentBookFund(Long bookId) {
		return super.getSqlSession().selectList(this.getStatement("getCurrentBookFund"), bookId);
	}

	/**
	 * 获取图书在基金支持的基金名称
	 */
	@Override
	public String getUseFundName(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(this.getStatement("getUseFundName"), paramMap);
	}

	/**
	 * 正在基金支持的图书
	 */
	@Override
	public Long getHaveFundBook(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(this.getStatement("getHaveFundBook"), paramMap);
	}

	/**
	 * 根据基金ID获取书刊基金信息
	 */
	@Override
	public BookFundDto getByBookFundId(Long bookFundId) {
		return super.getSqlSession().selectOne(this.getStatement("getByBookFundId"), bookFundId);
	}

	/**
	 * 正在基金支持的图书列表
	 */
	@Override
	public List<Long> listHaveFundBooks(List<Long> bookIds) {
		return super.getSqlSession().selectList(this.getStatement("listHaveFundBooks"), bookIds);
	}
	
	/**
	 * 获取所有正在基金支持的图书列表
	 */
	@Override
	public List<Long> listAllHaveFundBooks() {
		return super.getSqlSession().selectList(this.getStatement("listAllHaveFundBooks"));
	}

	/**
	 * 根据图书ID获取书刊基金信息
	 */
	@Override
	public BookFundInfoDto getUseFundInfo(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(this.getStatement("getUseFundInfo"),paramMap);
	}

	/**
	 * 是否基金支持的书
	 * @param bookId
	 * @return
	 */
    @Override
    public Boolean getIsHaveFundBefore(Long bookId) {
        return super.getSqlSession().selectOne(this.getStatement("getIsHaveFundBefore"),bookId);
    }

	@Override
	public Integer getFundBookCount() {
		return getSessionTemplate().selectOne(getStatement("getFundBookCount"));
	}

	@Override
	public List<BookFundDto> getListByBookIds(List<Long> bookIds) {
		Map<String, Object> paramMap=new HashMap<>();
		paramMap.put("bookIds",bookIds);
		return super.getSqlSession().selectList(this.getStatement("getListByBookIds"), paramMap);
	}

	@Override
	public BookFundDto getMaxEndTimeByBookId(Long bookId) {
		Map<String, Object> paramMap=new HashMap<>();
		paramMap.put("bookId",bookId);
		return super.getSqlSession().selectOne(this.getStatement("getMaxEndTimeByBookId"), paramMap);
	}

	@Override
	public Integer getCountByBatchNumber(String batchNumber) {
		Map<String, Object> paramMap=new HashMap<>();
		paramMap.put("batchNumber",batchNumber);
		return super.getSqlSession().selectOne(this.getStatement("getCountByBatchNumber"), paramMap);
	}
}
