package com.pcloud.book.book.entity;

import java.util.Date;
import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 书籍用户关联表(BookUserBrowseRecord)实体类
 *
 * @author wubo
 * @since 2021-12-03 10:40:19
 */
@Data
public class BookUserBrowseRecord extends BaseEntity {

    private static final long serialVersionUID = -85885294664372984L;

    @ApiModelProperty("书籍id")
    private Long bookId;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}
