package com.pcloud.book.consumer.shareimage;


import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.facade.shareimage.dto.HtmlDto;
import com.pcloud.facade.shareimage.facade.Htm2ImgService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Repository("shareImageConsr")
public class ShareImageConsr {

    @Autowired
    private Htm2ImgService htm2ImgService;

    @ParamLog("html转图片")
    public String toJPGByChrome(HtmlDto htmlDto){
        String img = null;
        try {
            img = ResponseHandleUtil.parseResponse(htm2ImgService.toJPGByChrome(htmlDto),String.class);
        }catch (Exception e){
            log.error("调用htm2ImgService.toJPGByChrome失败"+e.getMessage(),e);
        }
        return img;
    }


}
