package com.pcloud.book.copyright.dao.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.pcloud.book.copyright.dao.BookAuthCodeDao;
import com.pcloud.book.copyright.dto.BookAuthCodeDTO;
import com.pcloud.book.copyright.entity.BookAuthCode;
import com.pcloud.book.copyright.dto.HaveUsedAuthCode;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author lily
 * @date 2018/12/4 19:32
 */
@Component("bookAuthCodeDao")
public class BookAuthCodeDaoImpl extends BaseDaoImpl<BookAuthCode> implements BookAuthCodeDao {

    @Override
    public Integer getMaxBatchNum(Long bookId, Long channelId, Long adviserId, Integer authBookType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().selectOne(this.getStatement("getMaxBatchNum"), paramMap);
    }

    @Override
    public Integer updateUseCount(Long bookId, Long channelId, Long adviserId, String code, Integer codeUseCount, Integer authBookType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("codeUseCount",codeUseCount);
        paramMap.put("code",code);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().update(this.getStatement("updateUseCount"), paramMap);
    }

    @Override
    public Boolean getIsHaveCode(Long bookId, Long channelId, Long adviserId, String code, Integer authBookType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("code",code);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().selectOne(this.getStatement("getIsHaveCode"), paramMap);
    }

    @Override
    public Long getBookAuthCodeId(Long bookId, Long channelId, Long adviserId, String code, Integer authBookType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("code",code);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().selectOne(this.getStatement("getBookAuthCodeId"), paramMap);
    }

    @Override
    public void batchDeleteCode(List<Long> ids) {
        this.getSqlSession().delete(this.getStatement("batchDeleteCode"), ids);
    }

    @Override
    public List<BookAuthCodeDTO> getBookAuthCodeList(Map<String, Object> paramMap) {
        return this.getSessionTemplate().selectList(this.getStatement("getBookAuthCodeList"), paramMap);
    }

    @Override
    public BookAuthCodeDTO getBaseById(Long codeId) {
        return this.getSessionTemplate().selectOne(this.getStatement("getBaseById"), codeId);
    }

    @Override
    public BookAuthCode getByFullCode(String code) {
        return this.getSessionTemplate().selectOne(this.getStatement("getByFullCode"), code);
    }

    @Override
    public List<Long> getCodeIdList(Long bookId, Long channelId, Long adviserId, String keyWord, Integer authBookType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("keyword",keyWord);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().selectList(this.getStatement("getCodeIdList"), paramMap);
    }

    @Override
    public BookAuthCode getByAdviserAndCode(Long adviserId, String fullCode, Long bookId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("fullCode",fullCode);
        paramMap.put("adviserId",adviserId);
        return getSessionTemplate().selectOne(getStatement("getByAdviserAndCode"), paramMap);
    }

    @Override
    public void clearUseCount(Long id) {
        getSessionTemplate().update(getStatement("clearUseCount"), id);
    }

    @Override
    public void deleteCode(Long id) {
        getSqlSession().delete(getStatement("deleteCode"), ImmutableMap.of("id", id));
    }

    @Override
    public Integer updateUseCountById(Long authCodeId, Integer codeUseCount, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", authCodeId);
        paramMap.put("codeUseCount", codeUseCount);
        paramMap.put("adviserId", Optional.ofNullable(adviserId).orElse(0L));
        return getSqlSession().update(getStatement("updateUseCountById"), paramMap);
    }
}
