package com.pcloud.book.cultivate.dao.impl;

import com.pcloud.book.cultivate.dao.CultivateNotifyItemDao;
import com.pcloud.book.cultivate.dto.CultivateNotifyDTO;
import com.pcloud.book.cultivate.entity.CultivateNotifyItem;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("cultivateNotifyItemDao")
public class CultivateNotifyItemDaoImpl extends BaseDaoImpl<CultivateNotifyItem> implements CultivateNotifyItemDao {

    @Override
    public List<CultivateNotifyItem> getNotifyItemsByMessageId(Long messageId) {
         return super.getSessionTemplate().selectList(getStatement("getNotifyItemsByMessageId"),messageId);
    }

    @Override
    public List<CultivateNotifyItem> getByMessageIds(List<Long> messageIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("messageIds",messageIds);
        return super.getSqlSession().selectList(getStatement("getByMessageIds"), map);
    }

    @Override
    public List<CultivateNotifyItem> getNotifyItemsByMessageId4Jump(Long messageId) {
        return super.getSessionTemplate().selectList(getStatement("getNotifyItemsByMessageId4Jump"),messageId);
    }

    @Override
    public List<CultivateNotifyItem> getNotifyItemsByMessageIds4Jump(List<Long> messageIds) {
        return super.getSessionTemplate().selectList(getStatement("getNotifyItemsByMessageIds4Jump"),messageIds);

    }
}