package com.pcloud.book.group.biz;

import com.pcloud.book.group.dto.MultiChannelContentDTO;
import com.pcloud.book.group.entity.MultiChannelContent;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;

/**
 * (MultiChannelContent)表服务接口
 *
 * @author wubo 
 * @since 2022-06-06 19:11:46
 */
public interface MultiChannelContentBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    MultiChannelContent getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param multiChannelContent 实例对象
     * @return 主键
     */
    Long insert(MultiChannelContent multiChannelContent);

    /**
     * 修改数据
     *
     * @param multiChannelContent 实例对象
     */
    void update(MultiChannelContent multiChannelContent);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 通过主键软删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void softDeleteById(Long id);

    /**
     * 批量新增
     * @param multiChannelContentDTOS
     */
    void batchInsert(List<MultiChannelContentDTO> multiChannelContentDTOS);

    /**
     *
     * @param multiChannelContentIds
     * @return
     */
    List<MultiChannelContentDTO> selectList(List<Long> multiChannelContentIds);
}
