package com.pcloud.book.group.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.pcloud.book.group.dto.MultiChannelContentItemDTO;
import com.pcloud.book.group.entity.MultiChannelContentItem;
import com.pcloud.book.group.dao.MultiChannelContentItemDao;
import com.pcloud.book.group.biz.MultiChannelContentItemBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * (MultiChannelContentItem)表服务实现类
 *
 * @author wubo 
 * @since 2022-06-06 19:12:16
 */
@Service("multiChannelContentItemBiz")
public class MultiChannelContentItemBizImpl implements MultiChannelContentItemBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(MultiChannelContentItemBizImpl.class);

    @Autowired
    private MultiChannelContentItemDao multiChannelContentItemDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public MultiChannelContentItem getById(Long id) {
        return multiChannelContentItemDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = multiChannelContentItemDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(MultiChannelContentItem multiChannelContentItem) {
        multiChannelContentItemDao.insert(multiChannelContentItem);
        return multiChannelContentItem.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(MultiChannelContentItem multiChannelContentItem) {
        if(multiChannelContentItem == null || !NumberUtil.isNumber(multiChannelContentItem.getId())){
            throw BizException.PARAM_IS_NULL;
        }
        multiChannelContentItemDao.update(multiChannelContentItem);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        multiChannelContentItemDao.deleteById(id);
    }
    
    @Override
    @ParamLog("软删除")
    public void softDeleteById(Long id) {
     multiChannelContentItemDao.softDeleteById(id);
    }

    @Override
    public void insert(List<MultiChannelContentItem> multiChannelContentItems) {
        multiChannelContentItemDao.insert(multiChannelContentItems);
    }

    @Override
    public List<MultiChannelContentItemDTO> getByMultiChannelContentId(List<Long> multiChannelContentIds) {
        List<MultiChannelContentItemDTO> multiChannelContentItemDTOS = new ArrayList<>();
        if (CollUtil.isEmpty(multiChannelContentIds)) {
            return multiChannelContentItemDTOS;
        }
        List<MultiChannelContentItem> multiChannelContentItems =  multiChannelContentItemDao.getByMultiChannelContentId(multiChannelContentIds);
        if (CollUtil.isEmpty(multiChannelContentItems)) {
            return multiChannelContentItemDTOS;
        }
        multiChannelContentItemDTOS = BeanUtil.copyToList(multiChannelContentItems, MultiChannelContentItemDTO.class);
        return multiChannelContentItemDTOS;

    }
}
