package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.entity.MultiChannelContent;
import com.pcloud.book.group.dao.MultiChannelContentDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * (MultiChannelContent)表数据库访问层
 *
 * @author wubo 
 * @since 2022-06-06 19:11:46
 */
@Repository("multiChannelContentDaoImpl")
public class MultiChannelContentDaoImpl extends BaseDaoImpl<MultiChannelContent> implements MultiChannelContentDao {
    public int softDeleteById(Long id) {
             return getSessionTemplate().update(getStatement("softDeleteById"), id);

    }

    @Override
    public List<MultiChannelContent> selectList(List<Long> multiChannelContentIds) {
        return getSessionTemplate().selectList(getStatement("selectList"), multiChannelContentIds);
    }
}
